from app import db
from datetime import datetime

class Score(db.Model):
    """Model for storing game high scores"""
    id = db.Column(db.Integer, primary_key=True)
    score = db.Column(db.Integer, nullable=False)
    timestamp = db.Column(db.DateTime, nullable=False, default=datetime.utcnow)

    def __repr__(self):
        return f'<Score {self.score} at {self.timestamp}>'

    def to_dict(self):
        """Convert score to dictionary for JSON serialization"""
        return {
            'id': self.id,
            'score': self.score,
            'timestamp': self.timestamp.isoformat()
        }
